/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>
#import "ObjectCache.h"

#define COOKBOOK_PURPLE_COLOR	[UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) 	[[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]
#define NUMSTR(X) [NSString stringWithFormat:@"Alokacje: %d", X]

@interface TestBedViewController : UIViewController
{
	ObjectCache *objectCache;
    int nTimes;
}
@end

@implementation TestBedViewController

- (void)didReceiveMemoryWarning
{
    NSLog(@"Ostrzeżenie o niewielkiej ilości wolnej pamięci!");
	[objectCache respondToMemoryWarning];
    self.title = NUMSTR((nTimes = 0));
}

- (void) loadObject
{
	// Dzięki temu za każdym razem wczytywany jest inny obiekt. W przypadku 
	// dwukrotnego kliknięcia w ciągu sekundy, pobierany obiekt nie będzie
	// wygenerowany po raz drugi ponieważ data pozostaje bez zmian.
	[objectCache retrieveObjectNamed:[[NSDate date] description]];
    self.title = NUMSTR(++nTimes);
}

- (void) viewDidLoad
{
	objectCache = [ObjectCache cache];
    self.view.backgroundColor = [UIColor whiteColor];
	self.navigationController.navigationBar.tintColor = COOKBOOK_PURPLE_COLOR;
	self.navigationItem.rightBarButtonItem = BARBUTTON(@"Konsumpcja", @selector(loadObject));
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
    UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:[[TestBedViewController alloc] init]];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}